package com.bxm.localnews.facade;

import com.bxm.localnews.dto.InteractRankInfo;
import com.bxm.localnews.facade.fallback.ForumPostFallbackFactory;
import com.bxm.localnews.vo.*;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "localnews-news", fallbackFactory = ForumPostFallbackFactory.class, primary = false)
public interface ForumPostFeignService {

    @PostMapping("/facade/forumPost/createPost")
    ResponseEntity<Boolean> createPost(@RequestBody ForumBasicVo forumBasicVo);

    @ApiOperation(value = "4-95-5 获取帖子简略信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "postId", value = "帖子ID", required = true),
            @ApiImplicitParam(name = "areaCode", value = "访问请求来源用户所属区域编码"),
            @ApiImplicitParam(name = "areaName", value = "访问请求来源用户所属区域名称"),
            @ApiImplicitParam(name = "userId", value = "访问接口的用户ID")
    })
    @GetMapping("/facade/forumPost/briefInfo")
    ResponseEntity<ForumPostBriefInfoDto> getBriefInfo(@RequestParam("postId") Long postId,
                                                       @RequestParam(value = "areaCode", required = false) String areaCode,
                                                       @RequestParam(value = "areaName", required = false) String areaName,
                                                       @RequestParam(value = "userId", required = false) Long userId);

    @GetMapping(value = "/facade/forumPost/getTopicById")
    ResponseEntity<TopicFacadeVO> getTopicById(@RequestParam("id") Long id);

    @GetMapping("/facade/forumPost/forumRank")
    ResponseEntity<List<ForumRankVo>> forumRank(@RequestParam("areaCode") String areaCode,@RequestParam("userIds") List<Long> userIds);

    @GetMapping("/facade/forumPost/forumRankForUser")
    ResponseEntity<ForumPostRankForUserVo> forumRankForUser(@RequestParam("userId") Long userId);

    /**
     *  获取评论排行
     * @param areaCode
     * @param limitNum
     * @return
     */
    @GetMapping(value = "/facade/forumPost/interactRankInfo")
    ResponseEntity<List<InteractRankInfo>> getInteractRankInfo(@RequestParam("areaCode") String areaCode,
                                                               @RequestParam("limitNum") Integer limitNum, @RequestParam("userIds") List<Long> userIds);


    /**
     * 获取个人评论数
     * @param userId
     * @return
     */
    @GetMapping(value = "/facade/forumPost/replyNumForUser")
    ResponseEntity<Integer> replyNumForUser(@RequestParam("userId") Long userId);
}
