package com.bxm.localnews.facade;

import com.bxm.localnews.facade.fallback.NewsFallbackFactory;
import com.bxm.localnews.vo.NewsBriefInfoDto;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-news", fallbackFactory = NewsFallbackFactory.class, primary = false)
public interface NewsFeignService {

    @ApiOperation(value = "4-96-1 获取新闻简略信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻ID", required = true),
            @ApiImplicitParam(name = "areaCode", value = "访问请求来源用户所属区域编码"),
            @ApiImplicitParam(name = "userId", value = "访问接口的用户ID")
    })
    @GetMapping("/facade/news/briefInfo")
    ResponseEntity<NewsBriefInfoDto> getBriefInfo(@RequestParam("newsId") Long newsId,
                                                  @RequestParam(value = "areaCode", required = false) String areaCode,
                                                  @RequestParam(value = "userId", required = false) Long userId);
}
