package com.bxm.localnews.facade;

import com.bxm.localnews.facade.fallback.PushMsgSupplyFallbackFactory;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-msg", fallbackFactory = PushMsgSupplyFallbackFactory.class, primary = false)
public interface PushMsgSupplyFeignService {

    @PostMapping("/push")
    void pushMsg(@RequestBody PushMessage message);

    @PostMapping("/facade/user/event/add")
    void addUserEvent(@RequestBody PushPayloadInfo pushPayloadInfo);

    @PostMapping("/facade/msg/add")
    ResponseEntity<Boolean> addMsg(@RequestBody PushMessage pushMessage, @RequestParam("userId") Long userId);
}
