package com.bxm.localnews.facade;

import com.bxm.localnews.facade.fallback.QuartzManageFallbackFactory;
import com.bxm.localnews.param.HelpRemindParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "localnews-quartz", fallbackFactory = QuartzManageFallbackFactory.class, primary = false)
public interface QuartzManageFeignService {

    @PostMapping("/quartz/add/helpRemind")
    ResponseEntity<String> createHelpRemindTask(@RequestBody HelpRemindParam param);

    @PostMapping("/quartz/remove/helpRemind")
    ResponseEntity<String> removeHelpRemindTask();

}

