package com.bxm.localnews.facade;

import com.bxm.localnews.facade.fallback.SmsSupplyFallbackFactroy;
import com.bxm.localnews.mq.common.constant.SmsTemplateEnum;
import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-msg", fallbackFactory = SmsSupplyFallbackFactroy.class, primary = false)
public interface SmsSupplyFeignService {
    @PostMapping("/sms/tml")
    SendSmsResult sendSmsByTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO);

    @PostMapping("/sms/custom")
    SendSmsResult sendSmsByCustomize(@RequestBody SmsSupplyDTO smsSupplyDTO);

    @PostMapping("/sms/group/tml")
    void sendGroupSmsByTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO);

    @PostMapping("/sms/group/custom")
    void sendGroupSmsByCustomize(@RequestBody SmsSupplyDTO smsSupplyDTO);

    @GetMapping("/sms/verify")
    Boolean verifySmsCode(@RequestParam("phoneNo") String phoneNo,
                          @RequestParam("code") String code,
                          @RequestParam("smsTemplate") SmsTemplateEnum smsTemplate);

    @GetMapping("/sms/verify/type")
    Boolean verifySmsCodeByType(@RequestParam("type") Byte type,
                                @RequestParam("phoneNo") String phoneNo,
                                @RequestParam("code") String code);

    @PostMapping("/sms/tml/vcode")
    SendSmsResult sendSmsByVCodeTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO);
}
