package com.bxm.localnews.facade;

import com.bxm.localnews.dto.UserAccountDTO;
import com.bxm.localnews.facade.fallback.UserAccountFallbackFactory;
import com.bxm.localnews.param.AccountCashParam;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.newidea.component.vo.Message;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

@FeignClient(value = "localnews-user", fallbackFactory = UserAccountFallbackFactory.class, primary = false)
public interface UserAccountFeignService {

    @PostMapping("/facade/user/account/addCash")
    ResponseEntity<Boolean> addCash(@RequestBody AccountCashParam param);

    @GetMapping("/facade/user/account/able")
    ResponseEntity<BigDecimal> getUserDrawableCash(@RequestParam("userId") Long userId);

    @PostMapping("/facade/user/account/update")
    ResponseEntity<Message> updateUserWithdrawInfo(@RequestParam("userId") Long userId,
                                                   @RequestParam("amount") BigDecimal amount,
                                                   @RequestParam("withdrawState") Byte withdrawState);

    @PostMapping("/facade/user/account/addGold")
    ResponseEntity<Boolean> addGold(@RequestBody AccountGoldParam param);

    @GetMapping("/facade/user/account/totalCash")
    ResponseEntity<BigDecimal> getUserTotalCash(@RequestParam("userId") Long userId);

    @GetMapping("/facade/user/account/usableGold")
    ResponseEntity<Integer> getUserUsableGold(@RequestParam("userId") Long userId);

    @GetMapping("/facade/user/account/getUserAccount")
    ResponseEntity<UserAccountDTO> getUserAccount(@RequestParam("userId") Long userId);
}
