package com.bxm.localnews.facade;

import com.bxm.localnews.facade.fallback.UserAuthFallbackFactory;
import com.bxm.localnews.vo.UserAuth;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zhaoyadong 2019/3/2 11:04
 * @desc
 */
@FeignClient(value = "localnews-user", fallbackFactory = UserAuthFallbackFactory.class, primary = false)
public interface UserAuthFeignService {

    @GetMapping("facade/user/auth/info")
    ResponseEntity<UserAuth> selectUserAuthByOpenId(@RequestParam("openId") String openId);

    @GetMapping("facade/user/auth/info/unionId")
    ResponseEntity<UserAuth> selectUserAuthByUnionId(@RequestParam("unionId") String unionId);

    @GetMapping("facade/user/auth/info/selectAppletUserAuthByUserId")
    ResponseEntity<UserAuth> selectAppletUserAuthByUserId(@RequestParam("userId") Long userId,
                                                          @RequestParam("type") Byte type);

    @GetMapping("facade/user/auth/info/openId")
    ResponseEntity<UserAuth> selectUserAuthByAppOpenId(@RequestParam("userId") Long userId);

    @GetMapping("facade/user/auth/info/wechat/openId")
    ResponseEntity<UserAuth> selectUserAuthByUserId(@RequestParam("userId") Long userId);

    @GetMapping("facade/user/auth/info/selectAppletUserAuthByOpenId")
    ResponseEntity<UserAuth> selectAppletUserAuthByOpenId(@RequestParam("openId") String openId,
                                                          @RequestParam("type") Byte type);
}
