package com.bxm.localnews.facade;

import com.bxm.localnews.dto.InteractRankInfo;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.dto.UserInviteOrderVO;
import com.bxm.localnews.dto.UserTbkInfo;
import com.bxm.localnews.facade.fallback.UserFallbackFactory;
import com.bxm.localnews.param.UserActivationVipFacadeParam;
import com.bxm.localnews.param.UserParam;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.tools.Validater;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhaoyadong 2019/3/2 10:38
 * @desc
 */
@FeignClient(value = "localnews-user", fallbackFactory = UserFallbackFactory.class, primary = false)
public interface UserFeignService {

    @GetMapping("/facade/user/info")
    ResponseEntity<UserInfoDTO> getUserFromCache(@RequestParam("userId") Long userId);

    @GetMapping("/facade/user/headimg")
    ResponseEntity<String> getDefaultHeadImgUrl();

    @GetMapping("/facade/user/detail")
    ResponseEntity<User> selectByPrimaryKey(@RequestParam("userId") Long userId);

    @PostMapping("/facade/user/unionId")
    ResponseEntity<Boolean> checkUnionIdIsUser(@RequestParam("unionId") String unionId);

    @PostMapping("/facade/user/create")
    ResponseEntity<Message> createUser(@RequestBody UserParam userParam);

    @PostMapping("/facade/user/update")
    ResponseEntity<Message> updateUser(@RequestBody UserParam userParam);

    @GetMapping("/facade/user/temp")
    ResponseEntity<Boolean> isTempUser(@RequestParam("userId") Long userId);

    @GetMapping("/facade/user/risk")
    ResponseEntity<Boolean> isRiskUser(@RequestParam("userId") Long userId);

    @PostMapping("/facade/homepage/sendSystemMessage")
    ResponseEntity<Boolean> sendSystemMessage(@RequestParam(value = "userId") Long userId);

    /**
     * 判断用户的资料是否完整 true 完成 false 不完整
     * @param userId
     * @return
     */
    @GetMapping("/facade/user/personal-info/complete")
    ResponseEntity<Boolean> checkInfoComplete(@RequestParam(value = "userId") Long userId);

    @GetMapping("/facade/user/countRegUser")
    ResponseEntity<Integer> countRegUser(@RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime);

    @ApiOperation(value = "9-93-26 用户购买vip卡激活vip")
    @PostMapping("/facade/user/activationVip")
    ResponseEntity<Boolean> activationVip(@RequestBody UserActivationVipFacadeParam userActivationVipFacadeParam);

    /**
     * 9-93-27 根据userId 获取用户淘客信息
     * @param userId userId
     * @return 淘客信息
     */
    @GetMapping(value = "facade/user/selectUserFromCacheByUserId")
    ResponseEntity<UserTbkInfo> selectUserFromCacheByUserId(@RequestParam("userId") Long userId);

    /**
     *  获取评论排行
     * @param areaCode
     * @param limitNum
     * @return
     */
    @GetMapping(value = "facade/user/interactRankInfo")
    ResponseEntity<List<InteractRankInfo>> getInteractRankInfo(@RequestParam("areaCode") String areaCode,
                                                               @RequestParam("limitNum") Integer limitNum,@RequestParam("userIds") List<Long> userIds);


    /**
     * 获取个人评论数
     * @param userId
     * @return
     */
    @GetMapping(value = "facade/user/replyNumForUser")
    ResponseEntity<Integer> replyNumForUser(@RequestParam("userId") Long userId);

    /**
     * 是否关注
     * @param fromUserId
     * @param toUserId
     * @return
     */
    @GetMapping(value = "facade/user/isFollow")
    ResponseEntity<Boolean> isFollow(@RequestParam("fromUserId") Long fromUserId, @RequestParam("toUserId")
            Long toUserId);

    /**
     * 获取收徒榜信息
     * @param num
     * @return
     * @throws BindException
     */
    @GetMapping(value = "facade/user/invite/getOrderTen")
    ResponseEntity<List<UserInviteOrderVO>> getOrderTen(@RequestParam("num")Integer num,@RequestParam("areaCode")
            String areaCode,@RequestParam("userIds") List<Long> userIds) throws BindException;

    /**
     * 获取个人收徒数
     * @param userId
     * @return
     * @throws BindException
     */
    @GetMapping(value = "facade/user/invite/getInviteNumByUserId")
    ResponseEntity<UserInviteOrderVO> getInviteNumByUserId(@RequestParam("userId")Long userId) throws BindException;
    /**
     * 绑定临时的用户师徒关系
     * @param userId ： 用户id
     * @param inviteUserId ： 邀请人的用户id
     * @return
     * @throws BindException
     */
    @GetMapping(value = "facade/user/invite/bindInviteUserId")
    ResponseEntity<Boolean> bindInviteUserId(@RequestParam("userId")Long userId, @RequestParam("inviteUserId")Long inviteUserId) ;


}
