package com.bxm.localnews.facade;

import com.bxm.localnews.dto.UserRedPacketDTO;
import com.bxm.localnews.facade.fallback.UserRedPacketFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-user", fallbackFactory = UserRedPacketFallbackFactory.class, primary = false)
public interface UserRedPacketFeignService {

    @GetMapping("facade/user/redPacket/enable")
    ResponseEntity<UserRedPacketDTO> enableRedPacket(@RequestParam("devcId") String devcId,
                                                     @RequestParam("userId") Long userId,
                                                     @RequestParam("areaCode") String areaCode);

}
