package com.bxm.localnews.facade.fallback;

import java.math.BigDecimal;

import com.bxm.localnews.facade.AccountFeignService;
import com.bxm.localnews.param.DeductPointParam;

import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/3/15 10:47
 * @desc
 */
@Component
@Slf4j
public class AccountFallbackFactory implements FallbackFactory<AccountFeignService> {
    @Override
    public AccountFeignService create(Throwable throwable) {
        return new AccountFeignService() {
            @Override
            public ResponseEntity<Boolean> deductUserBalance(DeductPointParam deductPointParam) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Boolean.FALSE);
            }

            @Override
            public ResponseEntity<Boolean> deductConfirmUserBalance(DeductPointParam deductPointParam) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Boolean.FALSE);
            }

            @Override
            public void addUserBalance(DeductPointParam deductPointParam) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public ResponseEntity<BigDecimal> selectGoldBalanceByUserId(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(BigDecimal.ZERO);
            }
        };
    }
}
