package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.dto.InteractRankInfo;
import com.bxm.localnews.facade.ForumPostFeignService;
import com.bxm.localnews.vo.*;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@Slf4j
public class ForumPostFallbackFactory implements FallbackFactory<ForumPostFeignService> {
    @Override
    public ForumPostFeignService create(Throwable throwable) {
        return new ForumPostFeignService() {
            @Override
            public ResponseEntity<Boolean> createPost(ForumBasicVo forumBasicVo) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Boolean.FALSE);
            }

            @Override
            public ResponseEntity<ForumPostBriefInfoDto> getBriefInfo(Long postId, String areaCode, String areaName, Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new ForumPostBriefInfoDto());
            }

            @Override
            public ResponseEntity<TopicFacadeVO> getTopicById(Long id) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new TopicFacadeVO());
            }

            @Override
            public ResponseEntity<List<ForumRankVo>> forumRank(String areaCode,List<Long> userIds) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new ArrayList<>());
            }

            @Override
            public ResponseEntity<ForumPostRankForUserVo> forumRankForUser(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new ForumPostRankForUserVo());
            }

            @Override
            public ResponseEntity<List<InteractRankInfo>> getInteractRankInfo(String areaCode, Integer limitNum, List<Long> userIds) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new ArrayList<>());
            }

            @Override
            public ResponseEntity<Integer> replyNumForUser(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(0);
            }
        };
    }
}
