package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.facade.NewsFeignService;
import com.bxm.localnews.vo.NewsBriefInfoDto;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class NewsFallbackFactory implements FallbackFactory<NewsFeignService> {
    @Override
    public NewsFeignService create(Throwable throwable) {
        return (newsId, areaCode, userId) -> {
            log.error(throwable.getMessage(), throwable);
            return ResponseEntity.ok(new NewsBriefInfoDto());
        };
    }
}
