package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.facade.QuartzManageFeignService;
import com.bxm.localnews.param.HelpRemindParam;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class QuartzManageFallbackFactory implements FallbackFactory<QuartzManageFeignService> {
    @Override
    public QuartzManageFeignService create(Throwable throwable) {
        return new QuartzManageFeignService() {
            @Override
            public ResponseEntity<String> createHelpRemindTask(HelpRemindParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok("");
            }

            @Override
            public ResponseEntity<String> removeHelpRemindTask() {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok("");
            }

        };
    }
}

