package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.dto.InteractRankInfo;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.dto.UserInviteOrderVO;
import com.bxm.localnews.dto.UserTbkInfo;
import com.bxm.localnews.facade.UserFeignService;
import com.bxm.localnews.param.UserActivationVipFacadeParam;
import com.bxm.localnews.param.UserParam;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindException;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhaoyadong 2019/3/2 10:38
 * @desc
 */
@Component
@Slf4j
public class UserFallbackFactory implements FallbackFactory<UserFeignService> {

    @Override
    public UserFeignService create(Throwable throwable) {
        return new UserFeignService() {
            @Override
            public ResponseEntity<UserInfoDTO> getUserFromCache(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new UserInfoDTO());
            }

            @Override
            public ResponseEntity<String> getDefaultHeadImgUrl() {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(StringUtils.EMPTY);
            }

            @Override
            public ResponseEntity<User> selectByPrimaryKey(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new User());
            }

            @Override
            public ResponseEntity<Boolean> checkUnionIdIsUser(String unionId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Boolean.FALSE);
            }

            @Override
            public ResponseEntity<Message> createUser(UserParam userParam) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Message.build(Boolean.FALSE, "创建用户失败"));
            }

            @Override
            public ResponseEntity<Message> updateUser(UserParam userParam) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Message.build(Boolean.FALSE, "万事通小程序创建用户失败"));
            }

            @Override
            public ResponseEntity<Boolean> isTempUser(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Boolean.FALSE);
            }

            @Override
            public ResponseEntity<Boolean> isRiskUser(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Boolean.FALSE);
            }

            @Override
            public ResponseEntity<Boolean> sendSystemMessage(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Boolean.FALSE);
            }

            @Override
            public ResponseEntity<Integer> countRegUser(String startTime, String endTime) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(0);
            }

            @Override
            public ResponseEntity<Boolean> activationVip(UserActivationVipFacadeParam userActivationVipFacadeParam) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Boolean.FALSE);
            }

            @Override
            public ResponseEntity<UserTbkInfo> selectUserFromCacheByUserId(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(null);
            }

            @Override
            public ResponseEntity<List<InteractRankInfo>> getInteractRankInfo(String areaCode, Integer limitNum, List<Long> userIds) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new ArrayList<>());
            }

            @Override
            public ResponseEntity<Integer> replyNumForUser(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(0);
            }

            @Override
            public ResponseEntity<Boolean> isFollow(Long fromUserId, Long toUserId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Boolean.FALSE);
            }

            @Override
            public ResponseEntity<List<UserInviteOrderVO>> getOrderTen(Integer num, String areaCode,List<Long> userIds)
                    throws
                    BindException {
                log.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity<UserInviteOrderVO> getInviteNumByUserId(Long userId) throws BindException {
                log.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity<Boolean> checkInfoComplete(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Boolean.FALSE);
            }

            @Override
            public ResponseEntity<Boolean> bindInviteUserId(Long userId, Long inviteUserId) {

                return ResponseEntity.ok(Boolean.FALSE);
            }
        };
    }
}
