package com.bxm.localnews.integration;

import com.bxm.localnews.dto.InteractRankInfo;
import com.bxm.localnews.facade.ForumPostFeignService;
import com.bxm.localnews.vo.*;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Service
public class ForumPostIntegrationService {

    @Resource
    private ForumPostFeignService forumPostFeignService;

    public Boolean createPost(ForumBasicVo forumBasicVo) {
        return forumPostFeignService.createPost(forumBasicVo).getBody();
    }

    public ForumPostBriefInfoDto getPostBriefInfo(Long postId, Long userId, String areaCode, String areaName) {
        ResponseEntity<ForumPostBriefInfoDto> result = forumPostFeignService.getBriefInfo(postId, areaCode, areaName, userId);
        return result.getBody();
    }

    public TopicFacadeVO getTopicById(Long id) {
        ResponseEntity<TopicFacadeVO> topicById = forumPostFeignService.getTopicById(id);

        if (Objects.nonNull(topicById)) {
            return topicById.getBody();
        }

        return new TopicFacadeVO();
    }

    /**
     * 帖子排行
     * @param areaCode
     * @return
     */
    public List<ForumRankVo> forumRank(String areaCode,List<Long> userIds){
        ResponseEntity<List<ForumRankVo>> forumRank = forumPostFeignService.forumRank(areaCode,userIds);
        if(forumRank.hasBody()){
            return forumRank.getBody();
        }
        return new ArrayList<>();
    }

    /**
     * 个人帖子排行热度值
     * @param userId
     * @return
     */
    public ForumPostRankForUserVo forumRankForUser(Long userId){
        ResponseEntity<ForumPostRankForUserVo> forumFouUser = forumPostFeignService.forumRankForUser(userId);
        if(forumFouUser.hasBody()){
            return forumFouUser.getBody();
        }
        return new ForumPostRankForUserVo();
    }

    /**
     * 获取评论排行榜
     * @param areaCode
     * @param limitNum
     * @return
     */
    public List<InteractRankInfo> getInteractRankInfo(String areaCode,Integer limitNum ,List<Long> userIds){
        ResponseEntity<List<InteractRankInfo>> entity = forumPostFeignService.getInteractRankInfo(areaCode,limitNum,userIds);
        if(entity.hasBody()){
            return entity.getBody();
        }

        return new ArrayList<>();
    }

    /**
     * 获取个人评论数
     * @param userId
     * @return
     */
    public Integer replyNumForUser(Long userId){
        ResponseEntity<Integer> entity = forumPostFeignService.replyNumForUser(userId);
        if(entity.hasBody()){
            return entity.getBody();
        }

        return 0;
    }
}
