package com.bxm.localnews.integration;

import java.math.BigDecimal;
import com.bxm.localnews.facade.InviteRecordFeignService;
import com.bxm.localnews.vo.InviteRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InviteRecordIntegrationService {

    @Autowired
    private InviteRecordFeignService inviteRecordFeignService;

    public Long updateInviteCash(Long userId, Long invitedUserId, BigDecimal cash) {
        return inviteRecordFeignService.updateInviteCash(userId, invitedUserId, cash).getBody();
    }

    public InviteRecord getInviteRecordByInvitedUser(Long userId, Long invitedUserId) {
        return inviteRecordFeignService.getInviteRecordByInvitedUser(userId, invitedUserId).getBody();
    }

    public InviteRecord getInviteRecordById(Long userId, Long id) {
        return inviteRecordFeignService.getInviteRecordById(userId, id).getBody();
    }

}
