package com.bxm.localnews.integration;

import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.facade.PushMsgSupplyFeignService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.newidea.component.service.BaseService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * @author zhaoyadong 2019/3/14 15:58
 * @desc
 */
@Service
public class PushMsgIntegrationService extends BaseService {

    @Autowired
    private PushMsgSupplyFeignService pushMsgSupplyFeignService;

    @Autowired
    private BizConfigProperties bizConfigProperties;

    public void pushMsg(PushMessage pushMessage) {
        pushMsgSupplyFeignService.pushMsg(pushMessage);
    }

    /**
     * 添加用户消息到消息中心
     *
     * @param pushMessage 用户消息
     * @param userId      添加的目标用户
     * @return 添加结果
     */
    public Boolean addMsg(PushMessage pushMessage, Long userId) {
        return pushMsgSupplyFeignService.addMsg(pushMessage, userId).getBody();
    }

    /**
     * 推送好友助力信息
     *
     * @param number     剩余人数
     * @param wechatName 微信好友名称
     */
    public void pushHelpMessage(Long userId, String wechatName, Integer number) {
        String title = "【VIP激活进度】" + wechatName + "已成功助力您，还差" + number + "人可激活VIP";
        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.VIP_FRIEND_HELP);
        PushMessage message = PushMessage.build();
        message.setTitle(StringUtils.EMPTY);
        message.setContent(title);
        message.setType(TemplateTypeEnum.TRANSMISSION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
        message.setPayloadInfo(info);
        this.pushMsgSupplyFeignService.pushMsg((message));
    }

    /**
     * 推送成功激活vip的消息
     *
     * @param userId
     */
    public void pushActivationVipSuccessMessage(Long userId) {
        String title = "恭喜！您已成功激活VIP卡，光临线下合作门店，畅享折扣";
        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.VIP_ACTIVATION_SUCCESS);

        PushMessage message = PushMessage.build();
        message.setTitle(StringUtils.EMPTY);
        message.setContent(title);
        message.setType(TemplateTypeEnum.TRANSMISSION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
        message.setPayloadInfo(info);

        this.pushMsgSupplyFeignService.pushMsg((message));
    }

    /**
     * 向昨天签到但是今天没有签到的用户发送通知
     *
     * @param userIdSet
     */
    public void pushSignNotificationMsg(Set<Long> userIdSet) {
        PushMessage message = PushMessage.build();
        message.setTitle("签到提示");
        message.setContent("今天还没签到领小红花，快来换粮油大米");
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushGroup(new ArrayList<>(userIdSet)));
        PushPayloadInfo pushPayloadInfo = PushPayloadInfo.build(PushMessageEnum.OPEN_URL);
        pushPayloadInfo.setContent("今天还没签到领小红花，快来换粮油大米");
        pushPayloadInfo.setMsgId(nextId());
        pushPayloadInfo.addExtend("url", bizConfigProperties.getH5ServerHost() + "/dailySign.html?userId={userId}&areaCode={areaCode}&isLogin={isLogin}&areaName={areaName}");
        message.setPayloadInfo(pushPayloadInfo);
        this.pushMsg(message);
    }

    /**
     * 助力活动结束提醒
     *
     * @param url
     * @param userIdList
     */
    public void pushHelpActivityEndMsg(String url, List<Long> userIdList) {
        //活动结束提醒
        String title = "感谢你为蓝天救援队奉献了一份爱心，目前我们正在传递你的爱心，点击查看";
        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.OPEN_URL);
        info.addExtend("url", url);

        PushMessage message = PushMessage.build();
        message.setTitle("通知消息");
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushGroup(userIdList));
        message.setPayloadInfo(info);

        this.pushMsg(message);
    }

    public void pushHelpActivityNearlyEndMsg(Integer dayNum, String url, Long userId) {
        String title = "距离活动结束还有" + dayNum + "天，目前爱心助力目标还未达成，请邀请好友再助力一次吧！";
        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.OPEN_URL);
        info.addExtend("url", url);

        PushMessage message = PushMessage.build();
        message.setTitle("通知消息");
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
        message.setPayloadInfo(info);

        this.pushMsg(message);
    }

}
