package com.bxm.localnews.integration;

import com.bxm.localnews.dto.UserAccountDTO;
import com.bxm.localnews.facade.UserAccountFeignService;
import com.bxm.localnews.param.AccountCashParam;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

@Service
public class UserAccountIntegrationService {

    @Autowired
    private UserAccountFeignService userAccountFeignService;

    public Boolean addCash(AccountCashParam param) {
        return userAccountFeignService.addCash(param).getBody();
    }

    public BigDecimal getUserDrawableCash(Long userId) {
        return userAccountFeignService.getUserDrawableCash(userId).getBody();
    }

    public Message updateUserWithdraw(Long userId, BigDecimal amount, Byte withdrawState) {
        return userAccountFeignService.updateUserWithdrawInfo(userId, amount, withdrawState).getBody();
    }

    public Boolean addGold(AccountGoldParam param) {
        return userAccountFeignService.addGold(param).getBody();
    }

    public BigDecimal getUserTotalCash(Long userId) {
        return userAccountFeignService.getUserTotalCash(userId).getBody();
    }

    public Integer getUserUsableGold(Long userId) {
        return userAccountFeignService.getUserUsableGold(userId).getBody();
    }

    public UserAccountDTO getUserAccount(Long userId) {
        return userAccountFeignService.getUserAccount(userId).getBody();
    }
}
