package com.bxm.localnews.integration;

import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.dto.InteractRankInfo;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.dto.UserInviteOrderVO;
import com.bxm.localnews.dto.UserTbkInfo;
import com.bxm.localnews.facade.UserFeignService;
import com.bxm.localnews.param.UserActivationVipFacadeParam;
import com.bxm.localnews.param.UserParam;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import io.swagger.models.auth.In;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author zhaoyadong 2019/3/2 10:30
 * @desc
 */
@Slf4j
@Service
public class UserIntegrationService {

    private final UserFeignService userFeignService;

    private final BizConfigProperties bizConfigProperties;

    @Autowired
    public UserIntegrationService(UserFeignService userFeignService,
                                  BizConfigProperties bizConfigProperties) {
        this.userFeignService = userFeignService;
        this.bizConfigProperties = bizConfigProperties;
    }

    public UserInfoDTO getUserFromRedisDB(Long userId) {
        return userFeignService.getUserFromCache(userId).getBody();
    }

    @Cacheable(value = "getDefaultHeadImgUrl", sync = true)
    public String getDefaultHeadImgUrl() {
        return userFeignService.getDefaultHeadImgUrl().getBody();
    }

    public User selectByPrimaryKey(Long userId) {
        return userFeignService.selectByPrimaryKey(userId).getBody();
    }

    public Boolean checkUnionIdIsUser(String unionId) {
        return userFeignService.checkUnionIdIsUser(unionId).getBody();
    }

    public Message createUser(UserParam userParam) {
        return userFeignService.createUser(userParam).getBody();
    }

    public Message updateUser(UserParam userParam) {
        return userFeignService.updateUser(userParam).getBody();
    }

    public Boolean isTempUser(Long userId) {
        return userFeignService.isTempUser(userId).getBody();
    }

    public Boolean isRiskUser(Long userId) {
        return userFeignService.isRiskUser(userId).getBody();
    }

    public LocationDetailDTO getLocationByUser(User user) {
        LocationDetailDTO locationDetailDTO = null;
        if (user != null) {
            String adcode = user.getLocationCode();
            if (null != adcode) {
                locationDetailDTO = new LocationDetailDTO();
                BeanUtils.copyProperties(SpringContextHolder.getBean(LocationFacadeService.class).getLocationDetailByCode(adcode), locationDetailDTO);

            } else {
                locationDetailDTO = new LocationDetailDTO();
                BeanUtils.copyProperties(SpringContextHolder.getBean(LocationFacadeService.class).getLocationDetailByCode(bizConfigProperties.getLocationCode()),
                        locationDetailDTO);
            }
        }
        return locationDetailDTO;
    }

    @Async
    public void sendSystemMessage(Long userId) {
        userFeignService.sendSystemMessage(userId);
    }

    public Boolean checkInfoComplete(Long userId) {
        return userFeignService.checkInfoComplete(userId).getBody();
    }

    public Integer countRegUser(String startTime, String endTime) {
        return userFeignService.countRegUser(startTime, endTime).getBody();
    }

    public Boolean activationVip(UserActivationVipFacadeParam userActivationVipFacadeParam) {
        ResponseEntity<Boolean> responseEntity = userFeignService.activationVip(userActivationVipFacadeParam);
        if (responseEntity.hasBody()) {
            return responseEntity.getBody();
        }

        return Boolean.FALSE;
    }

    /**
     * 根据
     * @param userId  userId
     * @return 用户信息
     */
    public UserTbkInfo selectUserFromCacheByUserId(Long userId) {

        try {
            ResponseEntity<UserTbkInfo> userTbkInfoResponseEntity = userFeignService.selectUserFromCacheByUserId(userId);
            if (Objects.nonNull(userTbkInfoResponseEntity)) {
                return userTbkInfoResponseEntity.getBody();
            }

        } catch(Exception e) {
            log.error("获取用户信息失败userId :{}", userId, e);
        }
        return null;
    }

    /**
     * 获取评论排行榜
     * @param areaCode
     * @param limitNum
     * @return
     */
//    public List<InteractRankInfo> getInteractRankInfo(String areaCode,Integer limitNum ,List<Long> userIds){
//        ResponseEntity<List<InteractRankInfo>> entity = userFeignService.getInteractRankInfo(areaCode,limitNum,userIds);
//        if(entity.hasBody()){
//            return entity.getBody();
//        }
//
//        return new ArrayList<>();
//    }

    /**
     * 获取个人评论数
     * @param userId
     * @return
     */
//    public Integer replyNumForUser(Long userId){
//        ResponseEntity<Integer> entity = userFeignService.replyNumForUser(userId);
//        if(entity.hasBody()){
//            return entity.getBody();
//        }
//
//        return 0;
//    }

    /**
     * 是否关注
     * @param fromUserId
     * @param toUserId
     * @return
     */
    public boolean isFollow(Long fromUserId,Long toUserId){
        ResponseEntity<Boolean> entity = userFeignService.isFollow(fromUserId,toUserId);
        if(entity.hasBody()){
            return entity.getBody();
        }

        return false;
    }

    public List<UserInviteOrderVO> getOrderTen(Integer num,String areaCode,List<Long> userIds){
        try {
            ResponseEntity<List<UserInviteOrderVO>> entity = userFeignService.getOrderTen(num,areaCode,userIds);
            if(entity.hasBody()){
                return entity.getBody();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayList<>();
    }

    public UserInviteOrderVO getInviteNumByUserId(Long userId){
        try {
            ResponseEntity<UserInviteOrderVO> entity = userFeignService.getInviteNumByUserId(userId);
            if(entity.hasBody()){
                return entity.getBody();
            }
        } catch (BindException e) {
            e.printStackTrace();
        }
        return new UserInviteOrderVO();
    }
}
