package com.bxm.localnews.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/3/5 17:28
 * @desc
 */
@ApiModel(description = "创建用户传入参数")
public class UserParam {

    @ApiModelProperty("邀请人用户id")
    private Long inviteUserId;

    @ApiModelProperty("邀请途径")
    private String inviteType;

    @ApiModelProperty("用户对应类型的微信openId：微信公众号、微信小程序")
    private String openId;

    @ApiModelProperty("用户在微信开放平台下唯一的unionId")
    private String unionId;

    @ApiModelProperty("用户昵称")
    private String nickName;

    @ApiModelProperty("用户性别")
    private Byte sex;

    @ApiModelProperty("用户头像")
    private String headImg;

    @ApiModelProperty("注册ip")
    private String regIp;

    @ApiModelProperty("平台信息 1：安卓 2：IOS 3：H5")
    private String platform;

    @ApiModelProperty("注册地址")
    private String registeredAddress;

    @ApiModelProperty("注册关联id")
    private Long relationId;

    @ApiModelProperty("是否通过任务邀请，小程序特有，只有通过任务邀请的才给奖励")
    private Boolean taskInvited = false;

    @ApiModelProperty("地区编码")
    private String locationCode;

    @ApiModelProperty("地区名称")
    private String locationName;

    public Boolean getTaskInvited() {
        return taskInvited;
    }

    public void setTaskInvited(Boolean taskInvited) {
        this.taskInvited = taskInvited;
    }

    public String getInviteType() {
        return inviteType;
    }

    public void setInviteType(String inviteType) {
        this.inviteType = inviteType;
    }

    public Long getInviteUserId() {
        return inviteUserId;
    }

    public void setInviteUserId(Long inviteUserId) {
        this.inviteUserId = inviteUserId;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getUnionId() {
        return unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public Byte getSex() {
        return sex;
    }

    public void setSex(Byte sex) {
        this.sex = sex;
    }

    public String getHeadImg() {
        return headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg;
    }

    public String getRegIp() {
        return regIp;
    }

    public void setRegIp(String regIp) {
        this.regIp = regIp;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getRegisteredAddress() {
        return registeredAddress;
    }

    public void setRegisteredAddress(String registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public String getLocationCode() {
        return locationCode;
    }

    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }

    public String getLocationName() {
        return locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }
}
