package com.bxm.localnews.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel(description = "帖子基础详情")
public class ForumBasicVo {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("帖子标题")
    private String title;

    @ApiModelProperty("作者id")
    private Long userId;

    @ApiModelProperty("地区编码")
    private String areaCode;

    @ApiModelProperty("发帖地址")
    private String location;

    @ApiModelProperty("帖子文本")
    private String textField;

    @ApiModelProperty("帖子图片数组")
    private List<PostImgVo> postImgList;

    @ApiModelProperty("版块id")
    private Long forumId;

    @ApiModelProperty("话题id列表")
    private List<Long> topicIdList;

    @ApiModelProperty("额外内容，拼接在textField后，imgList前")
    private String extraContent;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getTextField() {
        return textField;
    }

    public void setTextField(String textField) {
        this.textField = textField;
    }

    public List<PostImgVo> getPostImgList() {
        return postImgList;
    }

    public void setPostImgList(List<PostImgVo> postImgList) {
        this.postImgList = postImgList;
    }

    public Long getForumId() {
        return forumId;
    }

    public void setForumId(Long forumId) {
        this.forumId = forumId;
    }

    public List<Long> getTopicIdList() {
        return topicIdList;
    }

    public void setTopicIdList(List<Long> topicIdList) {
        this.topicIdList = topicIdList;
    }

    public String getExtraContent() {
        return extraContent;
    }

    public void setExtraContent(String extraContent) {
        this.extraContent = extraContent;
    }
}
