package com.bxm.localnews.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: pf.w
 * @Date: 2020/6/2 19:44
 */
@Data
@ApiModel(description = "发帖榜")
public class ForumRankVo implements Serializable {

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("用户头像")
    private String userImg;

    @ApiModelProperty("用户昵称")
    private String userName;

    @ApiModelProperty("计算出的热度值 （帖子数*10+阅读PV/100+评论数*10）")
    private Integer contentQualityScore;

    @ApiModelProperty("点赞数")
    private Integer likeTotal;


    @ApiModelProperty("发布的最近两条帖子")
    List<ForumPostTitleInfoVo> postTitleInfo;
}
