package com.bxm.localnews.vo;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

@ApiModel(description = "用户实体")
public class User extends BaseBean {

    @ApiModelProperty("用户ID，同时也是用户的邀请码。如果是注册绑定则传递静默注册用户ID")
    private Long id;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户密码")
    private String password;

    @ApiModelProperty("用户手机号码")
    private String phone;

    @ApiModelProperty("用户头像路径")
    private String headImg;

    @ApiModelProperty(hidden = true)
    private int age;

    @ApiModelProperty(hidden = true)
    private Byte sex;

    @ApiModelProperty(hidden = true)
    private Byte level;

    @ApiModelProperty(hidden = true)
    private String weixin;

    @ApiModelProperty(hidden = true)
    private String qq;

    @ApiModelProperty(hidden = true)
    private String weibo;

    @ApiModelProperty(hidden = true)
    private Byte state;

    @ApiModelProperty("用户访问凭证")
    private String token;

    @ApiModelProperty(hidden = true)
    private Long expiretime;

    private String refreshtoken;

    @ApiModelProperty(hidden = true)
    private Date lastLoginTime;

    @ApiModelProperty(hidden = true)
    private Long channelId;

    @ApiModelProperty("是否新用户(首次注册)")
    private Byte isNew;

    @ApiModelProperty(hidden = true)
    private String registerClient;

    @ApiModelProperty("手机型号")
    private String phoneModel;

    @ApiModelProperty("设备号")
    private String equipment;

    @ApiModelProperty("注册地址")
    private String registeredAddress;

    @ApiModelProperty(hidden = true)
    private Date createTime;

    @ApiModelProperty(hidden = true)
    private Date updateTime;

    @ApiModelProperty(hidden = true)
    private String channelName;

    @ApiModelProperty(hidden = true)
    private String levelStr;

    @ApiModelProperty("生日(精确到日) [注册不需传]")
    private Date birthday;

    @ApiModelProperty("用户个人信息地址 [注册不需传]")
    private String address;

    @ApiModelProperty("用户注册时的请求IP [注册不需传]")
    private String regIp;

    @ApiModelProperty("用户最后登录时的IP [注册不需传]")
    private String lastLoginIp;

    @ApiModelProperty("定位区域编码 [注册不需传]")
    private String locationCode;

    @ApiModelProperty("定位区域名称 [注册不需传默认为北京]")
    private String locationName;

    @ApiModelProperty(value = "用户是否使用的临时昵称", hidden = true)
    private Byte isTempNickName;

    @ApiModelProperty(value = "用户是否使用的临时头像", hidden = true)
    private Byte isTempHeadImg;

    @ApiModelProperty(value = "是否能够领取新人红包")
    private Byte receiveRedPacket;

    @ApiModelProperty(value = "邀请人id")
    private Long inviteUserId;

    @ApiModelProperty(value = "邀请等级")
    private Integer inviteLevel;

    @ApiModelProperty(value = "注册来源")
    private String registerChannel;


    @ApiModelProperty(value = "用户是否是风险用户 0:否 1：是")
    private Byte risk;

    @ApiModelProperty(value = "发帖数")
    private Integer postNum = 0;

    @ApiModelProperty(value = "评论数")
    private Integer replyNum = 0;

    @ApiModelProperty(value = "注册关联id")
    private Long relationId;

    public User() {

    }

    public User(Long id, String nickname, String phone, String headImg, Integer age, Byte sex, Byte level,
                String weixin, String qq, String weibo, Byte state, String token, Long expiretime,
                String refreshtoken, Date lastLoginTime, Long channelId,
                Byte isNew, String registerClient, Date createTime, Date updateTime) {
        this.id = id;
        this.nickname = nickname;
        this.phone = phone;
        this.headImg = headImg;
        this.age = age;
        this.sex = sex;
        this.level = level;
        this.weixin = weixin;
        this.qq = qq;
        this.weibo = weibo;
        this.state = state;
        this.token = token;
        this.expiretime = expiretime;
        this.refreshtoken = refreshtoken;
        this.lastLoginTime = lastLoginTime;
        this.channelId = channelId;
        this.isNew = isNew;
        this.registerClient = registerClient;
        this.createTime = createTime;
        this.updateTime = updateTime;
    }

    public String getLevelStr() {
        return this.levelStr;
    }

    public void setLevelStr(String levelStr) {
        this.levelStr = levelStr;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname == null ? null : nickname.trim();
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone == null ? null : phone.trim();
    }

    public String getHeadImg() {
        return this.headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg == null ? null : headImg.trim();
    }

    public int getAge() {
        return age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public Byte getSex() {
        return this.sex;
    }

    public void setSex(Byte sex) {
        this.sex = sex;
    }

    public Byte getLevel() {
        return this.level;
    }

    public void setLevel(Byte level) {
        this.level = level;
    }

    public String getWeixin() {
        return this.weixin;
    }

    public void setWeixin(String weixin) {
        this.weixin = weixin == null ? null : weixin.trim();
    }

    public String getQq() {
        return this.qq;
    }

    public void setQq(String qq) {
        this.qq = qq == null ? null : qq.trim();
    }

    public String getWeibo() {
        return this.weibo;
    }

    public void setWeibo(String weibo) {
        this.weibo = weibo == null ? null : weibo.trim();
    }

    public Byte getState() {
        return this.state;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token == null ? null : token.trim();
    }

    public Long getExpiretime() {
        return this.expiretime;
    }

    public void setExpiretime(Long expiretime) {
        this.expiretime = expiretime;
    }

    public String getRefreshtoken() {
        return this.refreshtoken;
    }

    public void setRefreshtoken(String refreshtoken) {
        this.refreshtoken = refreshtoken == null ? null : refreshtoken.trim();
    }

    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public Long getChannelId() {
        return this.channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Byte getIsNew() {
        return this.isNew;
    }

    public void setIsNew(Byte isNew) {
        this.isNew = isNew;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getEquipment() {
        return this.equipment;
    }

    public void setEquipment(String equipment) {
        this.equipment = equipment;
    }

    public String getRegisterClient() {
        return this.registerClient;
    }

    public void setRegisterClient(String registerClient) {
        this.registerClient = registerClient;
    }

    public String getPhoneModel() {
        return this.phoneModel;
    }

    public void setPhoneModel(String phoneModel) {
        this.phoneModel = phoneModel;
    }

    public String getRegisteredAddress() {
        return this.registeredAddress;
    }

    public void setRegisteredAddress(String registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    public Date getBirthday() {
        return birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getRegIp() {
        return regIp;
    }

    public void setRegIp(String regIp) {
        this.regIp = regIp;
    }

    public String getLastLoginIp() {
        return lastLoginIp;
    }

    public void setLastLoginIp(String lastLoginIp) {
        this.lastLoginIp = lastLoginIp;
    }

    public String getLocationCode() {
        return locationCode;
    }

    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }

    public String getLocationName() {
        return locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public Byte getIsTempNickName() {
        return isTempNickName;
    }

    public void setIsTempNickName(Byte isTempNickName) {
        this.isTempNickName = isTempNickName;
    }

    public Byte getIsTempHeadImg() {
        return isTempHeadImg;
    }

    public void setIsTempHeadImg(Byte isTempHeadImg) {
        this.isTempHeadImg = isTempHeadImg;
    }

    public Byte getReceiveRedPacket() {
        return receiveRedPacket;
    }

    public void setReceiveRedPacket(Byte receiveRedPacket) {
        this.receiveRedPacket = receiveRedPacket;
    }

    public Long getInviteUserId() {
        return inviteUserId;
    }

    public void setInviteUserId(Long inviteUserId) {
        this.inviteUserId = inviteUserId;
    }

    public Integer getInviteLevel() {
        return inviteLevel;
    }

    public void setInviteLevel(Integer inviteLevel) {
        this.inviteLevel = inviteLevel;
    }

    public String getRegisterChannel() {
        return registerChannel;
    }

    public void setRegisterChannel(String registerChannel) {
        this.registerChannel = registerChannel;
    }

    public Byte getRisk() {
        return risk;
    }

    public void setRisk(Byte risk) {
        this.risk = risk;
    }

    public Integer getPostNum() {
        return postNum;
    }

    public void setPostNum(Integer postNum) {
        this.postNum = postNum;
    }

    public Integer getReplyNum() {
        return replyNum;
    }

    public void setReplyNum(Integer replyNum) {
        this.replyNum = replyNum;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }
}