/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.facade;

import com.bxm.localnews.dto.InteractRankInfo;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.dto.UserInviteOrderVO;
import com.bxm.localnews.dto.UserTbkInfo;
import com.bxm.localnews.facade.fallback.UserFallbackFactory;
import com.bxm.localnews.param.UserActivationVipFacadeParam;
import com.bxm.localnews.param.UserParam;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="localnews-user", fallbackFactory=UserFallbackFactory.class, primary=false)
public interface UserFeignService {
    @GetMapping(value={"/facade/user/info"})
    public ResponseEntity<UserInfoDTO> getUserFromCache(@RequestParam(value="userId") Long var1);

    @GetMapping(value={"/facade/user/headimg"})
    public ResponseEntity<String> getDefaultHeadImgUrl();

    @GetMapping(value={"/facade/user/detail"})
    public ResponseEntity<User> selectByPrimaryKey(@RequestParam(value="userId") Long var1);

    @PostMapping(value={"/facade/user/unionId"})
    public ResponseEntity<Boolean> checkUnionIdIsUser(@RequestParam(value="unionId") String var1);

    @PostMapping(value={"/facade/user/create"})
    public ResponseEntity<Message> createUser(@RequestBody UserParam var1);

    @PostMapping(value={"/facade/user/update"})
    public ResponseEntity<Message> updateUser(@RequestBody UserParam var1);

    @GetMapping(value={"/facade/user/temp"})
    public ResponseEntity<Boolean> isTempUser(@RequestParam(value="userId") Long var1);

    @GetMapping(value={"/facade/user/risk"})
    public ResponseEntity<Boolean> isRiskUser(@RequestParam(value="userId") Long var1);

    @PostMapping(value={"/facade/homepage/sendSystemMessage"})
    public ResponseEntity<Boolean> sendSystemMessage(@RequestParam(value="userId") Long var1);

    @GetMapping(value={"/facade/user/personal-info/complete"})
    public ResponseEntity<Boolean> checkInfoComplete(@RequestParam(value="userId") Long var1);

    @GetMapping(value={"/facade/user/countRegUser"})
    public ResponseEntity<Integer> countRegUser(@RequestParam(value="startTime") String var1, @RequestParam(value="endTime") String var2);

    @ApiOperation(value="9-93-26 \u7528\u6237\u8d2d\u4e70vip\u5361\u6fc0\u6d3bvip")
    @PostMapping(value={"/facade/user/activationVip"})
    public ResponseEntity<Boolean> activationVip(@RequestBody UserActivationVipFacadeParam var1);

    @GetMapping(value={"facade/user/selectUserFromCacheByUserId"})
    public ResponseEntity<UserTbkInfo> selectUserFromCacheByUserId(@RequestParam(value="userId") Long var1);

    @GetMapping(value={"facade/user/interactRankInfo"})
    public ResponseEntity<List<InteractRankInfo>> getInteractRankInfo(@RequestParam(value="areaCode") String var1, @RequestParam(value="limitNum") Integer var2, @RequestParam(value="userIds") List<Long> var3);

    @GetMapping(value={"facade/user/replyNumForUser"})
    public ResponseEntity<Integer> replyNumForUser(@RequestParam(value="userId") Long var1);

    @GetMapping(value={"facade/user/isFollow"})
    public ResponseEntity<Boolean> isFollow(@RequestParam(value="fromUserId") Long var1, @RequestParam(value="toUserId") Long var2);

    @GetMapping(value={"facade/user/invite/getOrderTen"})
    public ResponseEntity<List<UserInviteOrderVO>> getOrderTen(@RequestParam(value="num") Integer var1, @RequestParam(value="areaCode") String var2, @RequestParam(value="userIds") List<Long> var3) throws BindException;

    @GetMapping(value={"facade/user/invite/getInviteNumByUserId"})
    public ResponseEntity<UserInviteOrderVO> getInviteNumByUserId(@RequestParam(value="userId") Long var1) throws BindException;

    @GetMapping(value={"facade/user/invite/bindInviteUserId"})
    public ResponseEntity<Boolean> bindInviteUserId(@RequestParam(value="userId") Long var1, @RequestParam(value="inviteUserId") Long var2);
}

