/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.dto.InteractRankInfo;
import com.bxm.localnews.facade.ForumPostFeignService;
import com.bxm.localnews.vo.ForumBasicVo;
import com.bxm.localnews.vo.ForumPostBriefInfoDto;
import com.bxm.localnews.vo.ForumPostRankForUserVo;
import com.bxm.localnews.vo.ForumRankVo;
import com.bxm.localnews.vo.TopicFacadeVO;
import feign.hystrix.FallbackFactory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class ForumPostFallbackFactory
implements FallbackFactory<ForumPostFeignService> {
    private static final Logger log = LoggerFactory.getLogger(ForumPostFallbackFactory.class);

    public ForumPostFeignService create(final Throwable throwable) {
        return new ForumPostFeignService(){

            @Override
            public ResponseEntity<Boolean> createPost(ForumBasicVo forumBasicVo) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok((Object)Boolean.FALSE);
            }

            @Override
            public ResponseEntity<ForumPostBriefInfoDto> getBriefInfo(Long postId, String areaCode, String areaName, Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok((Object)new ForumPostBriefInfoDto());
            }

            @Override
            public ResponseEntity<TopicFacadeVO> getTopicById(Long id) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok((Object)new TopicFacadeVO());
            }

            @Override
            public ResponseEntity<List<ForumRankVo>> forumRank(String areaCode, List<Long> userIds) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new ArrayList());
            }

            @Override
            public ResponseEntity<ForumPostRankForUserVo> forumRankForUser(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok((Object)new ForumPostRankForUserVo());
            }

            @Override
            public ResponseEntity<List<InteractRankInfo>> getInteractRankInfo(String areaCode, Integer limitNum, List<Long> userIds) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new ArrayList());
            }

            @Override
            public ResponseEntity<Integer> replyNumForUser(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok((Object)0);
            }
        };
    }
}

