/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.integration;

import com.bxm.localnews.dto.InteractRankInfo;
import com.bxm.localnews.facade.ForumPostFeignService;
import com.bxm.localnews.vo.ForumBasicVo;
import com.bxm.localnews.vo.ForumPostBriefInfoDto;
import com.bxm.localnews.vo.ForumPostRankForUserVo;
import com.bxm.localnews.vo.ForumRankVo;
import com.bxm.localnews.vo.TopicFacadeVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ForumPostIntegrationService {
    @Resource
    private ForumPostFeignService forumPostFeignService;

    public Boolean createPost(ForumBasicVo forumBasicVo) {
        return (Boolean)this.forumPostFeignService.createPost(forumBasicVo).getBody();
    }

    public ForumPostBriefInfoDto getPostBriefInfo(Long postId, Long userId, String areaCode, String areaName) {
        ResponseEntity<ForumPostBriefInfoDto> result = this.forumPostFeignService.getBriefInfo(postId, areaCode, areaName, userId);
        return (ForumPostBriefInfoDto)result.getBody();
    }

    public TopicFacadeVO getTopicById(Long id) {
        ResponseEntity<TopicFacadeVO> topicById = this.forumPostFeignService.getTopicById(id);
        if (Objects.nonNull(topicById)) {
            return (TopicFacadeVO)topicById.getBody();
        }
        return new TopicFacadeVO();
    }

    public List<ForumRankVo> forumRank(String areaCode, List<Long> userIds) {
        ResponseEntity<List<ForumRankVo>> forumRank = this.forumPostFeignService.forumRank(areaCode, userIds);
        if (forumRank.hasBody()) {
            return (List)forumRank.getBody();
        }
        return new ArrayList<ForumRankVo>();
    }

    public ForumPostRankForUserVo forumRankForUser(Long userId) {
        ResponseEntity<ForumPostRankForUserVo> forumFouUser = this.forumPostFeignService.forumRankForUser(userId);
        if (forumFouUser.hasBody()) {
            return (ForumPostRankForUserVo)forumFouUser.getBody();
        }
        return new ForumPostRankForUserVo();
    }

    public List<InteractRankInfo> getInteractRankInfo(String areaCode, Integer limitNum, List<Long> userIds) {
        ResponseEntity<List<InteractRankInfo>> entity = this.forumPostFeignService.getInteractRankInfo(areaCode, limitNum, userIds);
        if (entity.hasBody()) {
            return (List)entity.getBody();
        }
        return new ArrayList<InteractRankInfo>();
    }

    public Integer replyNumForUser(Long userId) {
        ResponseEntity<Integer> entity = this.forumPostFeignService.replyNumForUser(userId);
        if (entity.hasBody()) {
            return (Integer)entity.getBody();
        }
        return 0;
    }
}

