/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.integration;

import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.facade.PushMsgSupplyFeignService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.newidea.component.service.BaseService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushMsgIntegrationService
extends BaseService {
    @Autowired
    private PushMsgSupplyFeignService pushMsgSupplyFeignService;
    @Autowired
    private BizConfigProperties bizConfigProperties;

    public void pushMsg(PushMessage pushMessage) {
        this.pushMsgSupplyFeignService.pushMsg(pushMessage);
    }

    public Boolean addMsg(PushMessage pushMessage, Long userId) {
        return (Boolean)this.pushMsgSupplyFeignService.addMsg(pushMessage, userId).getBody();
    }

    public void pushHelpMessage(Long userId, String wechatName, Integer number) {
        String title = "\u3010VIP\u6fc0\u6d3b\u8fdb\u5ea6\u3011" + wechatName + "\u5df2\u6210\u529f\u52a9\u529b\u60a8\uff0c\u8fd8\u5dee" + number + "\u4eba\u53ef\u6fc0\u6d3bVIP";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.VIP_FRIEND_HELP);
        PushMessage message = PushMessage.build();
        message.setTitle("");
        message.setContent(title);
        message.setType(TemplateTypeEnum.TRANSMISSION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.pushMsgSupplyFeignService.pushMsg(message);
    }

    public void pushActivationVipSuccessMessage(Long userId) {
        String title = "\u606d\u559c\uff01\u60a8\u5df2\u6210\u529f\u6fc0\u6d3bVIP\u5361\uff0c\u5149\u4e34\u7ebf\u4e0b\u5408\u4f5c\u95e8\u5e97\uff0c\u7545\u4eab\u6298\u6263";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.VIP_ACTIVATION_SUCCESS);
        PushMessage message = PushMessage.build();
        message.setTitle("");
        message.setContent(title);
        message.setType(TemplateTypeEnum.TRANSMISSION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.pushMsgSupplyFeignService.pushMsg(message);
    }

    public void pushSignNotificationMsg(Set<Long> userIdSet) {
        PushMessage message = PushMessage.build();
        message.setTitle("\u7b7e\u5230\u63d0\u793a");
        message.setContent("\u4eca\u5929\u8fd8\u6ca1\u7b7e\u5230\u9886\u5c0f\u7ea2\u82b1\uff0c\u5feb\u6765\u6362\u7cae\u6cb9\u5927\u7c73");
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushGroup(new ArrayList<Long>(userIdSet)));
        PushPayloadInfo pushPayloadInfo = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.OPEN_URL);
        pushPayloadInfo.setContent("\u4eca\u5929\u8fd8\u6ca1\u7b7e\u5230\u9886\u5c0f\u7ea2\u82b1\uff0c\u5feb\u6765\u6362\u7cae\u6cb9\u5927\u7c73");
        pushPayloadInfo.setMsgId(Long.valueOf(this.nextId()));
        pushPayloadInfo.addExtend("url", (Object)(this.bizConfigProperties.getH5ServerHost() + "/dailySign.html?userId={userId}&areaCode={areaCode}&isLogin={isLogin}&areaName={areaName}"));
        message.setPayloadInfo(pushPayloadInfo);
        this.pushMsg(message);
    }

    public void pushHelpActivityEndMsg(String url, List<Long> userIdList) {
        String title = "\u611f\u8c22\u4f60\u4e3a\u84dd\u5929\u6551\u63f4\u961f\u5949\u732e\u4e86\u4e00\u4efd\u7231\u5fc3\uff0c\u76ee\u524d\u6211\u4eec\u6b63\u5728\u4f20\u9012\u4f60\u7684\u7231\u5fc3\uff0c\u70b9\u51fb\u67e5\u770b";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.OPEN_URL);
        info.addExtend("url", (Object)url);
        PushMessage message = PushMessage.build();
        message.setTitle("\u901a\u77e5\u6d88\u606f");
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushGroup(userIdList));
        message.setPayloadInfo(info);
        this.pushMsg(message);
    }

    public void pushHelpActivityNearlyEndMsg(Integer dayNum, String url, Long userId) {
        String title = "\u8ddd\u79bb\u6d3b\u52a8\u7ed3\u675f\u8fd8\u6709" + dayNum + "\u5929\uff0c\u76ee\u524d\u7231\u5fc3\u52a9\u529b\u76ee\u6807\u8fd8\u672a\u8fbe\u6210\uff0c\u8bf7\u9080\u8bf7\u597d\u53cb\u518d\u52a9\u529b\u4e00\u6b21\u5427\uff01";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.OPEN_URL);
        info.addExtend("url", (Object)url);
        PushMessage message = PushMessage.build();
        message.setTitle("\u901a\u77e5\u6d88\u606f");
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.pushMsg(message);
    }
}

