/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.integration;

import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.dto.UserInviteOrderVO;
import com.bxm.localnews.dto.UserTbkInfo;
import com.bxm.localnews.facade.UserFeignService;
import com.bxm.localnews.param.UserActivationVipFacadeParam;
import com.bxm.localnews.param.UserParam;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.validation.BindException;

@Service
public class UserIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(UserIntegrationService.class);
    private final UserFeignService userFeignService;
    private final BizConfigProperties bizConfigProperties;

    @Autowired
    public UserIntegrationService(UserFeignService userFeignService, BizConfigProperties bizConfigProperties) {
        this.userFeignService = userFeignService;
        this.bizConfigProperties = bizConfigProperties;
    }

    public UserInfoDTO getUserFromRedisDB(Long userId) {
        return (UserInfoDTO)this.userFeignService.getUserFromCache(userId).getBody();
    }

    @Cacheable(value={"getDefaultHeadImgUrl"}, sync=true)
    public String getDefaultHeadImgUrl() {
        return (String)this.userFeignService.getDefaultHeadImgUrl().getBody();
    }

    public User selectByPrimaryKey(Long userId) {
        return (User)((Object)this.userFeignService.selectByPrimaryKey(userId).getBody());
    }

    public Boolean checkUnionIdIsUser(String unionId) {
        return (Boolean)this.userFeignService.checkUnionIdIsUser(unionId).getBody();
    }

    public Message createUser(UserParam userParam) {
        return (Message)this.userFeignService.createUser(userParam).getBody();
    }

    public Message updateUser(UserParam userParam) {
        return (Message)this.userFeignService.updateUser(userParam).getBody();
    }

    public Boolean isTempUser(Long userId) {
        return (Boolean)this.userFeignService.isTempUser(userId).getBody();
    }

    public Boolean isRiskUser(Long userId) {
        return (Boolean)this.userFeignService.isRiskUser(userId).getBody();
    }

    public LocationDetailDTO getLocationByUser(User user) {
        LocationDetailDTO locationDetailDTO = null;
        if (user != null) {
            String adcode = user.getLocationCode();
            if (null != adcode) {
                locationDetailDTO = new LocationDetailDTO();
                BeanUtils.copyProperties((Object)((LocationFacadeService)SpringContextHolder.getBean(LocationFacadeService.class)).getLocationDetailByCode(adcode), (Object)locationDetailDTO);
            } else {
                locationDetailDTO = new LocationDetailDTO();
                BeanUtils.copyProperties((Object)((LocationFacadeService)SpringContextHolder.getBean(LocationFacadeService.class)).getLocationDetailByCode(this.bizConfigProperties.getLocationCode()), (Object)locationDetailDTO);
            }
        }
        return locationDetailDTO;
    }

    @Async
    public void sendSystemMessage(Long userId) {
        this.userFeignService.sendSystemMessage(userId);
    }

    public Boolean checkInfoComplete(Long userId) {
        return (Boolean)this.userFeignService.checkInfoComplete(userId).getBody();
    }

    public Integer countRegUser(String startTime, String endTime) {
        return (Integer)this.userFeignService.countRegUser(startTime, endTime).getBody();
    }

    public Boolean activationVip(UserActivationVipFacadeParam userActivationVipFacadeParam) {
        ResponseEntity<Boolean> responseEntity = this.userFeignService.activationVip(userActivationVipFacadeParam);
        if (responseEntity.hasBody()) {
            return (Boolean)responseEntity.getBody();
        }
        return Boolean.FALSE;
    }

    public UserTbkInfo selectUserFromCacheByUserId(Long userId) {
        try {
            ResponseEntity<UserTbkInfo> userTbkInfoResponseEntity = this.userFeignService.selectUserFromCacheByUserId(userId);
            if (Objects.nonNull(userTbkInfoResponseEntity)) {
                return (UserTbkInfo)userTbkInfoResponseEntity.getBody();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25userId :{}", (Object)userId, (Object)e);
        }
        return null;
    }

    public boolean isFollow(Long fromUserId, Long toUserId) {
        ResponseEntity<Boolean> entity = this.userFeignService.isFollow(fromUserId, toUserId);
        if (entity.hasBody()) {
            return (Boolean)entity.getBody();
        }
        return false;
    }

    public List<UserInviteOrderVO> getOrderTen(Integer num, String areaCode, List<Long> userIds) {
        try {
            ResponseEntity<List<UserInviteOrderVO>> entity = this.userFeignService.getOrderTen(num, areaCode, userIds);
            if (entity.hasBody()) {
                return (List)entity.getBody();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayList<UserInviteOrderVO>();
    }

    public UserInviteOrderVO getInviteNumByUserId(Long userId) {
        try {
            ResponseEntity<UserInviteOrderVO> entity = this.userFeignService.getInviteNumByUserId(userId);
            if (entity.hasBody()) {
                return (UserInviteOrderVO)entity.getBody();
            }
        }
        catch (BindException e) {
            e.printStackTrace();
        }
        return new UserInviteOrderVO();
    }
}

