package com.bxm.localnews.market.dto;

import com.bxm.localnews.market.constant.CommissionType;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;

@Data
@Builder
public class CommissionPlatformFacadeDTO {

    @Tolerate
    public CommissionPlatformFacadeDTO() {
    }

    /**
     * 商品id
     */
    private Long goodsId;

    /**
     * vip 自购佣金金额
     */
    private BigDecimal vipPurchasePrice;

    /**
     * 普通自购佣金金额
     */
    private BigDecimal purchasePrice;

    /**
     * 小达人佣金
     * 3.10.0版本后的体系
     */
    private BigDecimal smallTalentCommission;

    /**
     * 中达人佣金
     * 3.10.0版本后的体系
     */
    private BigDecimal midTalentCommission;

    /**
     * 大达人佣金
     * 3.10.0版本后的体系
     */
    private BigDecimal bigTalentCommission;

    /**
     * 上级佣金
     * 3.10.0版本后的体系
     */
    private BigDecimal talentParentCommission;

    /**
     * 上上级佣金
     * 3.10.0版本后的体系
     */
    private BigDecimal talentGrandparentCommission;

    /**
     * 佣金比例信息
     */
    private PlatformCommissionRageConfigInfo platformCommissionRageConfigInfo;

    /**
     * 佣金的类型
     *
     * @see CommissionType
     */
    private Byte commissionType;

    /**
     * 业务主体 FOSSICKER: 趣淘金 LOCAL_NEWS: 万事通
     */
    private String srcApp;
}
