package com.bxm.localnews.market.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;

/**
 * 商品佣金返回类
 *
 * @author lowi
 * @date 2020/12/14 15:28
 */
@ApiModel("商品佣金")
@Data
@Builder
public class GoodsCommissionDTO {

    @ApiModelProperty("小达人佣金")
    private BigDecimal smallTalentCommission;

    @ApiModelProperty("中达人佣金")
    private BigDecimal midTalentCommission;

    @ApiModelProperty("大达人佣金")
    private BigDecimal bigTalentCommission;

    @ApiModelProperty("上级佣金")
    private BigDecimal parentCommission;

    @ApiModelProperty("上上级佣金")
    private BigDecimal grandparentCommission;

    @ApiModelProperty("总佣金")
    private BigDecimal totalCommission;


    /**
     * 小达人佣金比例
     */
    private BigDecimal smallTalentRate;


    /**
     * 小达人佣金比例
     */
    private BigDecimal midTalentRate;


    /**
     * 大达人佣金比例
     */
    private BigDecimal bigTalentRate;


    /**
     * 上级佣金比例
     */
    private BigDecimal parentRate;


    /**
     * 上上级佣金比例
     */
    private BigDecimal grandparentRate;


    /**
     * 上上级佣金比例
     */
    private BigDecimal totalRate;

    @Tolerate
    public GoodsCommissionDTO() {

    }

}
