package com.bxm.localnews.market.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(description = "商家基本信息")
public class MerchantInfo {
    @ApiModelProperty("商家id")
    private Long id;

    @ApiModelProperty("店铺名称")
    private String merchantName;

    @ApiModelProperty("商家店铺简称")
    private String shortName;

    @ApiModelProperty("省编码")
    private String provinceCode;

    @ApiModelProperty("市编码")
    private String cityCode;

    @ApiModelProperty("区编码")
    private String countyCode;

    @ApiModelProperty("详细地址信息")
    private String address;

    @ApiModelProperty("'联系人名称")
    private String manageName;

    @ApiModelProperty("联系电话")
    private String mobile;

    @ApiModelProperty("商家绑定的用户id")
    private Long userId;

    @ApiModelProperty("店铺可用状态 0未审核1审核上架2审核下架")
    private Integer isShelf;

    @ApiModelProperty("0未申请,未入驻1: 已入驻 未装修 2: 已入驻 已装修")
    private Integer settlementStatus;

    @ApiModelProperty("资质状态  0: 资质未提交 1: 资质已提待审核 2: 资质审核通过 3: 资质审核拒绝")
    private Integer qualificationStatus;

    @ApiModelProperty("logo图片地址")
    private String logo;

    @ApiModelProperty("商户一句话描述")
    private String des;

    @ApiModelProperty("商户行业分类id")
    private Long categoryId;

    @ApiModelProperty("开放时间 0: 全天开放 1: 指定时间开放")
    private Integer openType;

    @ApiModelProperty("营业开始时间 0000 为00:00")
    private String openTime;

    @ApiModelProperty("营业结束时间 0000 为00:00")
    private String closeTime;

    @ApiModelProperty("创建时间，也就是商家申请入驻时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date modifyTime;

    @ApiModelProperty("店铺头图的json数组字符串")
    private String headPics;

    @ApiModelProperty("相册图片地址的json数组集合")
    private String album;

    @ApiModelProperty("店铺详情描述")
    private String detailContent;

    @ApiModelProperty("最后一次递交申请资质认证的时间")
    private Date lastAuthTime;

    @ApiModelProperty("下架原因")
    private String removalReason;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("是否享有vip标志位")
    private Integer judgeMarker;

    @ApiModelProperty("经度")
    private BigDecimal lat;

    @ApiModelProperty("维度")
    private BigDecimal lng;

    @ApiModelProperty("商户所属地区")
    private String areaCode;

}
