/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.dto;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author jieliGG
 * @date 2020/8/25 19:41
 * 商家的相关比率配置
 **/
@Data
public class MerchantRateDTO {
    /**
     * 商家选择VIP折扣时，默认折扣 前提是：vip_discount = 1
     */
    private BigDecimal vipRebate = new BigDecimal("0.95");

    /**
     * 分享人是VIP的分成
     */
    @Deprecated
    private BigDecimal vipUserRate = BigDecimal.ZERO;

    /**
     * 分享人不是VIP的分成
     */
    @Deprecated
    private BigDecimal userRate = BigDecimal.ZERO;

    /**
     * 分享人是vip时，师傅的比率
     */
    @Deprecated
    private BigDecimal vipUserInviteRate = BigDecimal.ZERO;
    /**
     * 分享人不是vip时，师傅的比率
     */
    @Deprecated
    private BigDecimal userInviteRate = BigDecimal.ZERO;

    /**
     * 分享人是vip时，二级师傅的比率
     */
    @Deprecated
    private BigDecimal vipUserTwoInviteRate = BigDecimal.ZERO;

    /**
     * 分享人是vip时，师傅的比率
     */
    @Deprecated
    private BigDecimal userTwoInviteRate = BigDecimal.ZERO;

    /**
     * 手续费率
     */
    private BigDecimal serviceRate = new BigDecimal("0.006");

}
