/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author jieliGG
 * @date 2020/9/2 22:04
 **/
@Data
@ApiModel(description = "订单信息返回包装类")
public class OrderInfoFacadeDTO {
    private Long id;

    @ApiModelProperty("商品ID")
    private String goodsId;

    @ApiModelProperty("商品标题")
    private String goodsName;


    @ApiModelProperty("商品首图")
    private String imgUrl;

    private String relationId;

    private String specialId;


    @ApiModelProperty(" 淘宝订单号（标识不同产品，每个产品一个子订单号，可做为一比订单的唯一标识）")
    private String orderSn;


    @ApiModelProperty("父订单号（相同产品不同规格的统一标识）")
    private String orderParentSn;


    @ApiModelProperty("商品单价")
    private BigDecimal goodsPrice;

    /**
     * 商品数量
     */
    @ApiModelProperty("商品数量")
    private Long goodsNum;

    /**
     * 订单最终收入金额
     */
    @ApiModelProperty("订单最终收入金额")
    private BigDecimal payPrice;

    /**
     * 用户实际支付金额
     */
    @ApiModelProperty("用户实际支付金额")
    private BigDecimal userActualPayPrice;

    /**
     * 来源（目前淘宝）订单创建时间
     */
    @ApiModelProperty("来源（目前淘宝）订单创建时间")
    private Date sourceOrderCreateTime;

    /**
     * 来源（目前淘宝）订单结算时间
     */
    @ApiModelProperty("来源（目前淘宝）订单结算时间")
    private Date sourceOrderEarningTime;

    /**
     * 订单状态  0：待结算   1：已结算   2：失效
     */
    @ApiModelProperty("订单状态  0：待结算   1：已结算   2：失效")
    private Integer orderStatus;

    /**
     * 来源（目前淘宝）订单状态3：订单结算，12：订单付款， 13：订单失效，14：订单成功
     */
    @ApiModelProperty("来源（目前淘宝）订单状态3：订单结算，12：订单付款， 13：订单失效，14：订单成功")
    private Integer sourceOwnerOrderStatus;

    /**
     * 佣金  /元
     */
    @ApiModelProperty("佣金  /元")
    private BigDecimal commission;

    /**
     * vip自购返佣
     */
    @ApiModelProperty("vip自购返佣")
    private BigDecimal vipPurchaseCommission;

    /**
     * 自购返利佣金/元
     */
    @ApiModelProperty("自购返利佣金/元")
    private BigDecimal purchaseCommission;

    /**
     * 上级返利佣金/元
     */
    @ApiModelProperty("上级返利佣金/元")
    private BigDecimal parentCommission;

    /**
     * 上上级返利佣金/元
     */
    @ApiModelProperty("上上级返利佣金/元")
    private BigDecimal grandparentCommission;

    /**
     * 来源  TB:淘宝 MEITUAN:美团
     */
    @ApiModelProperty("来源  TB:淘宝 MEITUAN:美团")
    private String source;

    /**
     * 订单所属平台类型，包括天猫、淘宝、聚划算等
     * 美团
     */
    @ApiModelProperty("订单所属平台类型，包括天猫、淘宝、聚划算等")
    private String tbOrderType;

    /**
     * pid
     */
    @ApiModelProperty("pid")
    private String pid;

    /**
     * 场景订单场景类型，1:常规订单，2:渠道订单，3:会员运营订单
     */
    @ApiModelProperty("场景订单场景类型，1:常规订单，2:渠道订单，3:会员运营订单")
    private Integer type;

    /**
     * 订单类型 1: 购物订单 2:外卖, 3:365卡券，4：团油，5：KFC
     */
    @ApiModelProperty("订单类型 1: 购物订单 2:外卖, 3:365卡券，4：团油，5：KFC")
    private Integer orderType;

    /**
     * 订单优惠券金额
     */
    @ApiModelProperty("订单优惠券金额")
    private BigDecimal coupon;

    /**
     * 订单优惠券文案描述
     */
    @ApiModelProperty("订单优惠券文案描述")
    private String couponDesc;

    /**
     * 使用的优惠券ID
     */
    @ApiModelProperty("使用的优惠券ID")
    private Long userCouponId;

    /**
     * 订单所属人id 根据relation id获取到的
     */
    @ApiModelProperty("订单所属人id 根据relation id获取到的")
    private Long ownerUserId;

    /**
     * 订单的源数据
     */
    @ApiModelProperty("订单的源数据")
    private String sourceStr;

    /**
     * 记录生成时间
     */
    @ApiModelProperty("记录生成时间")
    private Date createTime;

    /**
     * 修改时间
     */
    @ApiModelProperty("修改时间")
    private Date modifyTime;

    /**
     * 核销码
     */
    @ApiModelProperty("核销码")
    private Long verificationCode;

    /**
     * 开通vip花了多少钱
     */
    @ApiModelProperty("开通vip花了多少钱")
    private BigDecimal openVip;

    /**
     * 用户名
     */
    @ApiModelProperty("用户名")
    private String ownerUserName;

    /**
     * 用户手机
     */
    @ApiModelProperty("用户手机")
    private String ownerUserPhone;

    /**
     * 订单返利类型（PURCHASE自购，SHARE分享）
     */
    @ApiModelProperty("订单返利类型（PURCHASE自购，SHARE分享）")
    private String orderProfitType;


    private static final long serialVersionUID = 1L;
}
