package com.bxm.localnews.market.facade;

import com.bxm.localnews.market.dto.CommissionPlatformFacadeDTO;
import com.bxm.localnews.market.facade.fallback.CommodityCommissionFallbackFacotry;
import com.bxm.newidea.component.vo.ResponseJson;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

@FeignClient(value = "fossicker-commodity", fallbackFactory = CommodityCommissionFallbackFacotry.class, primary = false)
public interface CommodityCommissionFeignService {

    /**
     * 4-52-1 获取平台返佣信息
     * @param goodsId 商品id
     * @param commissionPrice 订单佣金价格
     * @param payPrice 订单支付价格
     * @param goodsNum 商品数量
     * @param purchaseBySelf 是否自购
     * @param userId 用户id
     * @param vip 是否vip
     * @return 平台返佣信息
     */
    @GetMapping("facade/commodity/commission/getPlatformCommission")
    ResponseJson<CommissionPlatformFacadeDTO> getPlatformCommission(@RequestParam("goodsId") Long goodsId,
                                                                    @RequestParam("commissionPrice") BigDecimal commissionPrice,
                                                                    @RequestParam("payPrice") BigDecimal payPrice,
                                                                    @RequestParam("goodsNum") Long goodsNum,
                                                                    @RequestParam("purchaseBySelf") Boolean purchaseBySelf,
                                                                    @RequestParam("userId") Long userId,
                                                                    @RequestParam("vip") Boolean vip,
                                                                    @RequestParam("superiorUserId") Long superiorUserId,
                                                                    @RequestParam("srcApp") String srcApp);

    /**
     * 4-52-2 获取商品优惠券金额
     * @param goodsId 商品id
     * @return 商品优惠券金额
     */
    @GetMapping("facade/commodity/commission/getCouponPrice")
    ResponseJson<Double> getCouponPrice(@RequestParam("goodsId") Long goodsId);
}
