package com.bxm.localnews.market.facade;

import com.bxm.localnews.market.dto.CashCouponDTO;
import com.bxm.localnews.market.facade.fallback.MerchantCouponFallbackFactory;
import com.bxm.localnews.market.param.UserCouponOrderParam;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 商家优惠券相关的接口
 *
 * @author liujia
 * @date 2020-09-28 14:31
 **/
@FeignClient(value = "localnews-merchant", fallbackFactory = MerchantCouponFallbackFactory.class, primary = false)
@RequestMapping("facade/merchant/coupon")
public interface MerchantCouponFeignService {

    @ApiOperation(value = "11-91-01 获取可用的现金优惠券信息", notes = "如果返回null则表示优惠券不存在或已不可使用")
    @RequestMapping("getUserCouponInfo")
    ResponseEntity<CashCouponDTO> getUserCouponInfo(@RequestParam("userCouponId") Long userCouponId);

    @ApiOperation(value = "11-91-02 用户下单时锁定优惠券", notes = "锁定优惠券信息，将其更新为待确认状态")
    @PostMapping("lock")
    ResponseEntity<Message> lockUserCoupon(@RequestBody UserCouponOrderParam param);

    @ApiOperation(value = "11-91-03 用户取消订单数，释放优惠券", notes = "将用户优惠券还原恢复原始状态")
    @PostMapping("release")
    ResponseEntity<Message> releaseUserCoupon(@RequestBody UserCouponOrderParam param);

    @ApiOperation(value = "11-91-04 订单付款成功，消费优惠券")
    @PostMapping("consume")
    ResponseEntity<Message> consumeUserCoupon(@RequestBody UserCouponOrderParam param);
}
