package com.bxm.localnews.market.facade;

import com.bxm.localnews.market.dto.GoodsCommissionDTO;
import com.bxm.localnews.market.dto.MerchantRateDTO;
import com.bxm.localnews.market.facade.fallback.MerchantGoodsFallbackFactory;
import com.bxm.localnews.market.model.dto.MerchantGoodsInfoDTO;
import com.bxm.localnews.market.model.vo.MerchantInfoSimpleVO;
import com.bxm.localnews.market.param.AfterOrderPaySuccessParam;
import com.bxm.localnews.market.param.OperatorMerchantAccountParam;
import com.bxm.newidea.component.vo.Message;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author jieliGG
 * @date 2020/8/25 20:04
 **/
@FeignClient(value = "localnews-merchant", fallbackFactory = MerchantGoodsFallbackFactory.class, primary = false)
public interface MerchantGoodsFeignService {
    /**
     * 获取商家的商品配置信息
     *
     * @return 商家的商品配置信息
     */
    @GetMapping("facade/merchant/getMerchantGoodsRateProperties")
    ResponseEntity<MerchantRateDTO> getMerchantGoodsRate();

    /**
     * 退还商品的库存
     *
     * @param goodsId : 商品id
     * @param num     : 退还数量
     * @return 退还结果
     */
    @GetMapping("facade/merchant/returnGoodsNum")
    ResponseEntity<Boolean> returnGoodsNum(@RequestParam("goodsId") Long goodsId, @RequestParam("num") Long num);

    /**
     * 操作商家账户
     *
     * @param accountContext ： 账户参数
     * @return ： 操作结果
     */
    @PostMapping("facade/merchant/operatorMerchantAccount")
    ResponseEntity<Boolean> operatorMerchantAccount(@RequestBody OperatorMerchantAccountParam accountContext);

    /**
     * 获取商家商品信息
     *
     * @param goodsId ： 商品id
     * @return : 商家商品信息
     */
    @GetMapping("facade/merchant/getGoodsInfoById")
    ResponseEntity<MerchantGoodsInfoDTO> getMerchantGoodsById(@RequestParam("goodsId") Long goodsId);


    /**
     * 通过商品id获取商户信息
     *
     * @param goodsId 商品id
     * @return 商户信息
     */
    @GetMapping("facade/merchant/getMerchantInfoSimpleInfo")
    ResponseEntity<MerchantInfoSimpleVO> getMerchantInfoSimpleInfo(@RequestParam("goodsId") Long goodsId);


    /**
     * 通过商品id获取商户信息
     *
     * @param goodsId 商品id
     * @param num: 订单数量
     * @return 商户信息
     */
    @GetMapping("facade/merchant/subOrderNum")
    ResponseEntity<Boolean> subOrderNum(@RequestParam("goodsId") Long goodsId,@RequestParam("num") Integer num);


    /**
     * 通过商品id校验商品的购买信息
     *
     * @param goodsId 商品id
     * @param num: 订单数量
     * @param userId 用户id
     * @return 是否可以购买
     */
    @GetMapping("facade/merchant/checkGoodsStatus")
    ResponseEntity<Message> checkGoodsStatus(@RequestParam("goodsId") Long goodsId, @RequestParam("num") Integer num,
                                             @RequestParam("userId") Long userId);


    /**
     * 根据商品id获取商品的佣金
     *
     * @param goodsId 商品id
     * @param isVip 是否VIP
     * @return 商品佣金信息
     */
    @GetMapping("facade/merchant/earnings/getCommission")
    ResponseEntity<GoodsCommissionDTO> getCommission(@RequestParam("goodsId") Long goodsId, @RequestParam("isVip") Boolean isVip);


    /**
     * 商家商品下单支付成功之后的处理
     * @param param
     */
    @PostMapping("facade/merchant/goods/afterOrderPaySuccess")
    void afterOrderPaySuccess(@RequestBody AfterOrderPaySuccessParam param);

}
