package com.bxm.localnews.market.facade;

import com.bxm.localnews.market.dto.MerchantInfo;
import com.bxm.localnews.market.facade.fallback.MerchantInfoFallbackFactory;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 商家优惠券相关的接口
 *
 * @author liujia
 * @date 2020-09-28 14:31
 **/
@FeignClient(value = "localnews-merchant", fallbackFactory = MerchantInfoFallbackFactory.class, primary = false)
@RequestMapping("facade/merchant")
public interface MerchantInfoFeignService {

    @ApiOperation("11-90-16 根据商家id获取商家信息")
    @GetMapping("getMerchantInfo")
    ResponseEntity<MerchantInfo> getMerchantInfo(@RequestParam("merchantId") Long merchantId);

}
