package com.bxm.localnews.market.facade;

import com.bxm.localnews.market.facade.fallback.MsgPushFallbackFactory;
import com.bxm.localnews.mq.common.param.WechatMpPushMessage;
import com.bxm.newidea.component.vo.Message;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author lowi
 * @date 2021/1/8 10:19
 */
@FeignClient(value = "localnews-msg", fallbackFactory = MsgPushFallbackFactory.class, primary = false)
public interface MsgPushFeignService {

    /**
     * 推送公众号消息
     *
     * @param wechatMpPushMessage 消息体
     * @return
     */
    @PostMapping("facade/officialAccount/push")
    ResponseEntity<Message> officialAccountPush(@RequestBody WechatMpPushMessage wechatMpPushMessage);
}
