package com.bxm.localnews.market.facade;


import com.bxm.localnews.market.facade.fallback.UserAccountFallbackFactory;
import com.bxm.localnews.market.param.AccountCashParam;
import com.bxm.localnews.market.param.AccountGoldParam;
import com.bxm.localnews.market.param.CashAccountParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 用户账户服务
 *
 * @author donghy
 */
@FeignClient(value = "localnews-user", fallbackFactory = UserAccountFallbackFactory.class,primary = false)
public interface UserAccountFeignService {

    @PostMapping("facade/user/account/addGold")
    ResponseEntity<Boolean> addGold(@RequestBody AccountGoldParam param);

    /**
     * 现金账户操作
     *
     * @param param 操作参数
     * @return 处理结果
     */
    @PostMapping("facade/account/cash/operation")
    ResponseEntity cashAccountOperation(@RequestBody CashAccountParam param);

    /**
     * 9-94-2 用户余额操作
     *
     * @param param 账户余额入参
     * @return 处理结果
     */
    @PostMapping("facade/user/account/addCash")
    ResponseEntity<Boolean> cashAccount(@RequestBody AccountCashParam param);
}
