package com.bxm.localnews.market.facade;

import com.bxm.localnews.market.dto.*;
import com.bxm.localnews.market.facade.fallback.UserFallbackFactory;
import com.bxm.localnews.market.param.IncreaseTalentDataParam;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import com.bxm.newidea.component.vo.Message;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "localnews-user", fallbackFactory = UserFallbackFactory.class ,primary = false)
public interface UserFeignService {

    /**
     * 获取用户详细信息
     *
     * @param userId
     * @return
     */
    @GetMapping(value = "facade/user/info")
    ResponseEntity<UserInfoDTO> selectUserFromCache(@RequestParam("userId") Long userId);

    /**
     * 9-93-26 根据淘客relation id 获取用户淘客信息
     *
     * @param relationId 淘客relation id
     * @return 淘客信息
     */
    @GetMapping(value = "facade/user/selectUserFromCacheByRelationId")
    ResponseEntity<UserTbkInfo> selectUserFromCacheByRelationId(@RequestParam("relationId") String relationId);

    /**
     * 9-93-27 根据userId 获取用户淘客信息
     *
     * @param userId userId id
     * @return 淘客信息
     */
    @GetMapping(value = "facade/user/selectUserFromCacheByUserId")
    ResponseEntity<UserTbkInfo> selectUserFromCacheByUserId(@RequestParam("userId") Long userId);

    /**
     * 9-93-29 更新标志位
     */
    @GetMapping("facade/user/updateUserJudgeMarker")
    ResponseEntity<Boolean> updateUserJudgeMarker(@RequestParam("userId") Long userId,
                                                  @RequestParam("judgeMarker") LocalNewsUserJudgeMarkerEnum judgeMarker,
                                                  @RequestParam("add") Boolean add);

    /**
     * 根据脱敏手机号码模糊匹配用户
     *
     * @param sensitivePhone 脱敏手机号码 如138****7542
     * @return 用户手机号码信息
     */
    @GetMapping("facade/user/sensitivePhoneUserInfo")
    ResponseEntity<List<UserPhoneDTO>> getUserInfoBySensitivePhone(@RequestParam("sensitivePhone") String sensitivePhone);

    /**
     * 根据手机号码获取用户id
     *
     * @param phone 手机号码
     * @return
     */
    @GetMapping("facade/user/phoneUserInfo")
    ResponseEntity<UserPhoneDTO> getUserInfoByPhone(
            @RequestParam("phone") String phone);

    /***
     * 获取邀请好友的信息
     * @param userId ： 用户id
     * @return ： 返回邀请记录，但是要判断state=1的才是真正的关系哦！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！
     */
    @GetMapping("facade/user/invite/info")
    ResponseEntity<UserInviteHistoryDTO> getInviteInfo(@RequestParam("userId") Long userId);


    /**
     * 增加达人贡献订单数量
     *
     * @param param param
     * @return 操作结果
     */
    @PostMapping("facade/user/talent//increase")
    ResponseEntity<Message> increaseTalentData(@RequestBody IncreaseTalentDataParam param);

    /**
     * 9-100-2 获取暂时绑定关系接口
     * @param userId userId
     * @return 暂时绑定关系接口
     */
    @GetMapping("facade/user/talent/getBindInfo")
    ResponseEntity<TalentBindDTO> getBindInfo(@RequestParam("userId") Long userId);


    /**
     * 获取达人的上级和上上级达人信息
     * @param userId userId
     * @return 团队信息
     */
    @GetMapping("facade/user/talent/getSuperiorInfo")
    ResponseEntity<TalentSuperiorInfoDTO> getSuperiorInfo(@RequestParam("userId") Long userId);

    /**
     * 9-92-07 根据userId获取是否关注微信公众号
     * @param userId
     * @return
     */
    @GetMapping("facade/user/auth/isFocusOfficialAccount")
    ResponseEntity<Boolean> isFocusOfficialAccount(@RequestParam("userId") Long userId);


    /**
     * 判断用户是否关注了对方
     *
     * @param fromUserId fromUserId
     * @param toUserId toUserId
     * @return 是否关注
     */
    @GetMapping("facade/user/isFollow")
    ResponseEntity<Boolean> isFollow(@RequestParam("fromUserId") Long fromUserId, @RequestParam("toUserId") Long toUserId);

}
