package com.bxm.localnews.market.facade.fallback;

import com.bxm.localnews.market.facade.CommodityCommissionFeignService;
import com.bxm.localnews.market.dto.CommissionPlatformFacadeDTO;
import com.bxm.newidea.component.vo.ResponseJson;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

@Slf4j
@Component
public class CommodityCommissionFallbackFacotry implements FallbackFactory<CommodityCommissionFeignService> {
    @Override
    public CommodityCommissionFeignService create(Throwable throwable) {

        return new CommodityCommissionFeignService() {


            @Override
            public ResponseJson<CommissionPlatformFacadeDTO> getPlatformCommission(Long goodsId, BigDecimal commissionPrice,
                                                                                   BigDecimal payPrice, Long goodsNum,
                                                                                   Boolean purchaseBySelf, Long userId,
                                                                                   Boolean vip, Long superiorUserId,
                                                                                   String site) {
                log.error(throwable.getMessage(), throwable);
                return ResponseJson.badReqeuset().build();
            }

            @Override
            public ResponseJson<Double> getCouponPrice(Long goodsId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseJson.badReqeuset().build();
            }
        };
    }
}
