package com.bxm.localnews.market.facade.fallback;

import com.bxm.localnews.market.facade.CommodityInfoFeignService;
import com.bxm.newidea.component.vo.ResponseJson;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class CommodityInfoFallbackFactory implements FallbackFactory<CommodityInfoFeignService> {


    @Override
    public CommodityInfoFeignService create(Throwable throwable) {

        return new CommodityInfoFeignService() {

            @Override
            public ResponseJson<String> getTaoBaoUnionStr(Long adzoneId, String relationId,
                                                          Long promotionSceneId, String appName) {
                log.error(throwable.getMessage(), throwable);
                return ResponseJson.badReqeuset().build();
            }


            @Override
            public ResponseJson<String> createTaoWord(String url, String logUrl, String text) {
                log.error(throwable.getMessage(), throwable);
                return ResponseJson.badReqeuset().build();
            }
        };
    }
}
