package com.bxm.localnews.market.facade.fallback;

import com.bxm.localnews.market.dto.CashCouponDTO;
import com.bxm.localnews.market.facade.MerchantCouponFeignService;
import com.bxm.localnews.market.param.UserCouponOrderParam;
import com.bxm.newidea.component.vo.Message;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author liujia
 * @date 2020-09-28 14:33
 **/
@Component
@Slf4j
public class MerchantCouponFallbackFactory implements FallbackFactory<MerchantCouponFeignService> {

    @Override
    public MerchantCouponFeignService create(Throwable cause) {
        return new MerchantCouponFeignService() {
            @Override
            public ResponseEntity<CashCouponDTO> getUserCouponInfo(Long userCouponId) {
                log.error(cause.getMessage(), cause);
                return null;
            }

            @Override
            public ResponseEntity<Message> lockUserCoupon(UserCouponOrderParam param) {
                log.error(cause.getMessage(), cause);
                return ResponseEntity.ok(Message.build(false, "锁定优惠券失败"));
            }

            @Override
            public ResponseEntity<Message> releaseUserCoupon(UserCouponOrderParam param) {
                log.error(cause.getMessage(), cause);
                return ResponseEntity.ok(Message.build(false, "回滚优惠券失败"));
            }

            @Override
            public ResponseEntity<Message> consumeUserCoupon(UserCouponOrderParam param) {
                log.error(cause.getMessage(), cause);
                return ResponseEntity.ok(Message.build(false, "核销优惠券失败"));
            }
        };
    }
}
