package com.bxm.localnews.market.facade.fallback;

import com.bxm.localnews.market.dto.GoodsCommissionDTO;
import com.bxm.localnews.market.dto.MerchantRateDTO;
import com.bxm.localnews.market.facade.MerchantGoodsFeignService;
import com.bxm.localnews.market.model.dto.MerchantGoodsInfoDTO;
import com.bxm.localnews.market.model.vo.MerchantInfoSimpleVO;
import com.bxm.localnews.market.param.AfterOrderPaySuccessParam;
import com.bxm.localnews.market.param.OperatorMerchantAccountParam;
import com.bxm.newidea.component.vo.Message;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * 商家商品服务熔断降级
 *
 * @author wzy
 * @date 2020/8/10 23:06
 **/
@Slf4j
@Component
public class MerchantGoodsFallbackFactory implements FallbackFactory<MerchantGoodsFeignService> {
    @Override
    public MerchantGoodsFeignService create(Throwable throwable) {
        return new MerchantGoodsFeignService() {
            @Override
            public ResponseEntity<MerchantRateDTO> getMerchantGoodsRate() {
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> returnGoodsNum(Long goodsId, Long num) {
                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity<Boolean> operatorMerchantAccount(OperatorMerchantAccountParam accountContext) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity<MerchantGoodsInfoDTO> getMerchantGoodsById(Long goodsId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<MerchantInfoSimpleVO> getMerchantInfoSimpleInfo(Long goodsId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> subOrderNum(Long goodsId, Integer num) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Message> checkGoodsStatus(Long goodsId, Integer num, Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<GoodsCommissionDTO> getCommission(Long goodsId, Boolean isVip) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public void afterOrderPaySuccess(AfterOrderPaySuccessParam param) {
                log.error(throwable.getMessage(), throwable);
            }
        };
    }
}
