package com.bxm.localnews.market.facade.fallback;

import com.bxm.localnews.market.dto.MerchantInfo;
import com.bxm.localnews.market.facade.MerchantInfoFeignService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author liujia
 * @date 2020-09-28 14:33
 **/
@Component
@Slf4j
public class MerchantInfoFallbackFactory implements FallbackFactory<MerchantInfoFeignService> {

    @Override
    public MerchantInfoFeignService create(Throwable cause) {
        return new MerchantInfoFeignService() {
            @Override
            public ResponseEntity<MerchantInfo> getMerchantInfo(Long merchantId) {
                return ResponseEntity.badRequest().build();
            }
        };
    }
}
