package com.bxm.localnews.market.facade.fallback;

import com.bxm.localnews.market.facade.MessageSmsFeignService;
import com.bxm.localnews.market.facade.UserVipFeignService;
import com.bxm.localnews.market.model.param.ActivationUserVipParam;
import com.bxm.localnews.market.param.VipQueryParam;
import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import com.bxm.localnews.user.model.VipInfoDetailDTO;
import feign.hystrix.FallbackFactory;
import org.springframework.http.ResponseEntity;

/**
 * 用户vip服务熔断降级
 *
 * @author wzy
 * @date 2020/8/10 23:06
 **/
public class MessageSmsFallbackFactory implements FallbackFactory<MessageSmsFeignService> {
    @Override
    public MessageSmsFeignService create(Throwable throwable) {
        return new MessageSmsFeignService() {
            @Override
            public SendSmsResult sendSmsByCustomize(SmsSupplyDTO smsSupplyDTO) {
                return new SendSmsResult();
            }
        };
    }
}
