package com.bxm.localnews.market.facade.fallback;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.market.facade.MsgPushFeignService;
import com.bxm.localnews.mq.common.param.WechatMpPushMessage;
import com.bxm.newidea.component.vo.Message;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;

/**
 * @author lowi
 * @date 2021/1/8 10:20
 */
@Slf4j
public class MsgPushFallbackFactory implements FallbackFactory<MsgPushFeignService> {

    @Override
    public MsgPushFeignService create(Throwable throwable) {
        return new MsgPushFeignService() {
            @Override
            public ResponseEntity<Message> officialAccountPush(WechatMpPushMessage wechatMpPushMessage) {
                log.error("公众号消息推送失败：{}", JSON.toJSONString(wechatMpPushMessage), throwable);
                return ResponseEntity.ok(Message.build(false));
            }
        };
    }
}
