package com.bxm.localnews.market.facade.fallback;

import com.bxm.localnews.market.dto.PaymentOrderInfoDTO;
import com.bxm.localnews.market.facade.PaymentInfoFeignService;
import com.bxm.localnews.market.model.dto.PaymentOrderDTO;
import com.bxm.localnews.market.model.param.order.UserOrderParam;
import com.bxm.localnews.market.param.RefundParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.ResponseJson;
import feign.hystrix.FallbackFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @Author: pf.w
 * @Date: 2020/7/14 10:18
 */
@Component
public class PaymentInfoFallbackFactory implements FallbackFactory<PaymentInfoFeignService> {
    @Override
    public PaymentInfoFeignService create(Throwable throwable) {
        return new PaymentInfoFeignService() {
            @Override
            public ResponseJson<PaymentOrderDTO> orderCreate(UserOrderParam param) {
                return ResponseJson.badReqeuset().build();
            }

            @Override
            public ResponseJson<Message> refund(RefundParam param) {
                return ResponseJson.badReqeuset().build();
            }

            @Override
            public ResponseEntity<PaymentOrderInfoDTO> getPaymentNumByOrderSn(String orderSn) {
                return ResponseEntity.badRequest().build();
            }
        };
    }
}
