package com.bxm.localnews.market.facade.fallback;

import com.bxm.localnews.market.dto.*;
import com.bxm.localnews.market.facade.UserFeignService;
import com.bxm.localnews.market.param.IncreaseTalentDataParam;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import com.bxm.newidea.component.vo.Message;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

@Slf4j
@Component
public class UserFallbackFactory implements FallbackFactory<UserFeignService> {

    @Override
    public UserFeignService create(Throwable throwable) {
        return new UserFeignService() {
            @Override
            public ResponseEntity<UserInfoDTO> selectUserFromCache(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<UserTbkInfo> selectUserFromCacheByRelationId(String relationId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<UserTbkInfo> selectUserFromCacheByUserId(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> updateUserJudgeMarker(Long userId, LocalNewsUserJudgeMarkerEnum judgeMarker, Boolean add) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<List<UserPhoneDTO>> getUserInfoBySensitivePhone(String sensitivePhone) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<UserPhoneDTO> getUserInfoByPhone(String phone) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<UserInviteHistoryDTO> getInviteInfo(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Message> increaseTalentData(IncreaseTalentDataParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<TalentBindDTO> getBindInfo(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<TalentSuperiorInfoDTO> getSuperiorInfo(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> isFocusOfficialAccount(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> isFollow(Long fromUserId, Long toUserId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(false);
            }
        };
    }
}
