package com.bxm.localnews.market.facade.fallback;

import com.bxm.localnews.market.dto.PayInfoDTO;
import com.bxm.localnews.market.facade.WithdrawFeignService;
import com.bxm.newidea.component.vo.Message;
import feign.hystrix.FallbackFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

@Component
public class WithdrawFallbackFactory implements FallbackFactory<WithdrawFeignService> {

    @Override
    public WithdrawFeignService create(Throwable throwable) {

        return new WithdrawFeignService() {
            @Override
            public ResponseEntity<Message> appletWithdraw(Long userId, String openId, BigDecimal amount, String devcId, String ip) {
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<PayInfoDTO> getVipInfo() {
                return ResponseEntity.badRequest().build();
            }
        };

    }

}
